extern PyObject *ModulesArray[];
extern int ModulesArrayIndex;

extern void Load_Module(const char* filename);


extern int *CommandsCount;
//extern ConsoleCommand *CommandsArray;

typedef void (*_SortCommands)();
//extern _SortCommands SortCommands;

typedef void (*_UpdateCommands)();
//extern _UpdateCommands UpdateCommands;

class ConsoleCommand
{
public:
	virtual const char *GetName() = 0;
	virtual const char *GetAlias() = 0;
	virtual const char *GetHelp() = 0;
	virtual void Activate(const char *CommandLine) = 0;
	virtual ~ConsoleCommand();
	static void InstallCommands();
	ConsoleCommand();
};

class ConsoleCommand_PyExecute : public ConsoleCommand {
public:
	virtual const char* GetName();
	virtual const char* GetAlias();
	virtual const char* GetHelp();
	virtual void Activate(const char* CommandLine);

};

class ConsoleCommand_PyLoad : public ConsoleCommand {
public:
	virtual const char* GetName();
	virtual const char* GetAlias();
	virtual const char* GetHelp();
	virtual void Activate(const char* CommandLine);

};

class ConsoleCommand_PyReload : public ConsoleCommand {
public:
	virtual const char* GetName();
	virtual const char* GetAlias();
	virtual const char* GetHelp();
	virtual void Activate(const char* CommandLine);

};

class ConsoleCommand_PyReloadAll : public ConsoleCommand {
public:
	virtual const char* GetName();
	virtual const char* GetAlias();
	virtual const char* GetHelp();
	virtual void Activate(const char* CommandLine);

};